-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );

CopyrightFont = {
  copyrightFont,
  10,
  WhiteColor
};

MoreGamesColor		= Color(161,244,234,255);


kButtonSpacing	= 95;
kButtonSpacing2	= 80;
kBoard			= 460;
kButtonX		= 475;
kButtonY		= kBoard+5;
kLeftButtonX	= kButtonX+40- 4*kButtonSpacing;			--correction for left Button interface
kChangePlayX	= kCenter -40;
kChangePlayY	= kBoard + 70;
kOptionsX		= kCenter + 57;
kOptionsY		= kChangePlayY;
k64BtuttonY		= kButtonY+30;
kSmallTextY		= 30;

kButtonXOffset  = 30;

function CheckUsers()
	if (GetNumUsers() == 0) then
		gEnterNameValue = "";
		name = DoModal("scripts/entername.lua");
		if (not(name == nil)) then
			CreateNewUser(name);
			return true ;
		end
		return false ;
	else
		return true;
	end
end

function QuitGame()
	CloseWindow();
end


function MakeMedalButton()
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);
				
	if not anonHS then
		return Group
		{
			SBButton
			{
				x=kButtonX  + 2*kButtonSpacing+15 + 2*kButtonXOffset,
				y=k64BtuttonY,
				name="trophiesbtn",
				label = "trophies",
				icon="assets/images/ui/buttons/icon/icontrophy",
				command =
					function()
						DoModal("scripts/medals.lua");
					end
			};
		};
	else
		return Group
		{
		};
	end
end

MakeDialog
{
	-- Name the modal dialog
	name="mainmenu",
	
	MainMenu
	{
		fit=true;
		name = "mainmenuLayer";
		Bitmap
		{
			name="backgroundimage",
			image="images/backgrounds/tittlecard01",

			Bitmap
			{
				x = kCenter+1,
				y = kBoard+2,
				name="backgroundimage",
				image="images/buttons/mainmenu/tittlehud01",	
			},
			SetStyle(FitnessButtonStyleTittleYellow),
-- Story
			SBButton
			{
				x=kButtonX + 2*kButtonXOffset,
				y=kButtonY,
				name="game.mode.career.label",
				label="game.mode.career.label",
				icon="assets/images/ui/buttons/icon/iconstory",
				
				flags = kHAlignLeft + kVAlignTop,
				command=
					function()
						if (CheckUsers()) then
							-- Tell TSettings what game mode we're entering
							SetCurrentGameMode(0); -- Story Mode
							-- Switch to the appropriate screen
							PopModal("mainmenu");
							if(IsFirstTime() == 1) then
								StartComicMusic();
								SetComicOff();
								SetState("ComicScreenTime",1);
								SetState("StoryModeSessionTime",1);
								DoModal("scripts/comic1_1.lua");
							else
								SetState("StoryModeSessionTime",1);
								DoModal("scripts/metamap.lua");
							end
						end
					end
			},
			Text
			{
				font = SmallFontBlack,
				name = "playTx",
				x=kButtonX  + kButtonSpacing/2-5 + 2*kButtonXOffset,
				y=kButtonY+46,
				flags = kHAlignCenter + kVAlignCenter,
				label = "ui.label.mode"
			};
			SetStyle(FitnessButtonStyleTittleGreen),
			
-- Endlesss
			SBButton
			{
				x=kButtonX  + kButtonSpacing + 2*kButtonXOffset,
				y=kButtonY,
				name="game.mode.arcade.label",
				label="game.mode.arcade.label",
				icon="assets/images/ui/buttons/icon/iconendless",
				command=
				 	function()
						-- Set up the number of rows and columns
				 		gRows=5; gColumns=5;
				 		if (CheckUsers()) then

							-- Switch to the appropriate screen
				 			DoModal("scripts/endlesschoice.lua");							
				 		end
				 	end
			},
--Trophies
			SetStyle(FitnessButtonStyleTittleSmallBlue2),
			
			MakeMedalButton();

--Highscores
			SBButton
			{
				x=kLeftButtonX - kButtonXOffset,
				y=k64BtuttonY,
				name="highscores",
				icon="assets/images/ui/buttons/icon/iconhighscore",
				command=
					function()						
						DoModal("scripts/hiscore.lua");
					end
			},
			Text
			{
				font = BtnFont,
				name = "txhscores",
				x=kLeftButtonX-20 - kButtonXOffset,
				y=k64BtuttonY+45,
				flags = kHAlignCenter | kVAlignCenter,
				w=100,
				h=30,
				label = "highscores",
			};
			
--Help
			SBButton
			{
				x=kLeftButtonX  + kButtonSpacing2 - kButtonXOffset,
				y=k64BtuttonY,
				name="help",
				icon="assets/images/ui/buttons/icon/iconhelp",
				label = "help",
				command=
					function()
						SetState("HelpScreenTime",1);
						DoModal("scripts/help1.lua");
					end
			},
			

--Options
			SBButton
			{
				x = kChangePlayX + kButtonSpacing2,
				y = kChangePlayY,
				name="options",
				icon="assets/images/ui/buttons/icon/iconoption",
				label="options",
				command=
					function()
						DoModal("scripts/options.lua");
					end
			},
			Text
			{
				font = PlayerSmallFont,
				name = "txplayername",
				x	= kCenter,
				y	= kBoard+24,
				flags = kHAlignCenter | kVAlignTop,
				w=200,
				h=30,
				label="ui.label.playername"
			};	
--			SetStyle(FitnessButtonStyleTittleSmallBlue3),
--More Games
			SBButton
			{
				x=kLeftButtonX  - kButtonSpacing2 - kButtonXOffset,
				y=k64BtuttonY,
				name="moregames",
				icon="assets/images/ui/buttons/icon/iconmoregames",
				
				command=
					function()
						--PauseMainMenuScreenTimer();
						DoModal("xsell/xsell.lua");
					end
			},
			Text
			{
				font = BtnFont,
				name = "moregamelabel",
				x=kLeftButtonX  - kButtonSpacing2-10 - kButtonXOffset,
				y=k64BtuttonY+45,
				flags = kHAlignCenter | kVAlignCenter,
				w=80,
				h=30,
				label="ui.dialog.highscores.global.more_games.label",	
			};	
			
--Change Player
			SBButton
			{
				
				x			= kChangePlayX,
				y			= kChangePlayY,
				name		= "changeplayer",
				icon		= "assets/images/ui/buttons/icon/iconchangeplayer",
				
				command=
					function()
						DoModal("scripts/chooseplayer.lua");
					end
			},
			Text
			{
				font = BtnFont,
				name = "txplayername",
				x			= kChangePlayX-2,
				y			= kChangePlayY+45,
				flags = kHAlignCenter | kVAlignCenter,
				w=100,
				h=30,
				label		= "changeplayer",
			};
			SetStyle(FitnessButtonStyleQuit),
--Quit
			SBButton
			{
				x=kButtonX+ 2*kButtonSpacing+8 + kButtonXOffset+28,
				y=kButtonY +102,
				name="quit",
				label="quit",
				icon="assets/images/ui/buttons/icon/iconquit",
				command=
					function()
						result = DisplayDialog {
							"scripts/yesno.lua",
							body ="quitconfirm",
							title = "quittitle"
						};
						if (result=='yes') then
							PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
						end
					end
			},
			
 --Name
  			Text
			{
				font = PlayerFont,
				name = "welcome",
				x=kCenter -2,
				y=kBoard+29,
				w=kMax,h=50,
				flags = kHAlignCenter | kVAlignCenter,
			--	label = "welcome"
			};
			Text
			{
				font = CopyrightFont,
				name="copyright",
				label="copyright",
				x= 40,
				y=kMax-20,
				w=kMax,
				h=20;
				flags = kHAlignLeft + kVAlignCenter,
			},
		},
	}
}